<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FreelancerPersonalInfo extends Model 
{

    protected $table = 'fl_personal_infos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fl_users_id', 'name', 'profile_photo', 'gender', 'state', 'address', 'pin');

    public function freelanceUser()
    {
        return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id');
    }

}